class Tower_Slith extends Tower;

var Pawn Target2;

state TacticalMove
{
ignores SeePlayer, HearNoise;

	function FireAtEnemy()
	{
	local Pawn P;
	local float ClosestOne,ClosestTwo;
	local Pawn Target;
	local float Range;
	local PBPRI PRI;

	PRI = PBPRI(PlayerPawn(TowerOwner).PlayerReplicationInfo);
	
	if ( PRI.KrallLevel == 0 )
		Range = 250;
	else if ( PRI.KrallLevel >= 1 )
		Range = 350;
	
	Target = None;
	Target2 = None;
	
	for ( P=Level.PawnList; P!=None; P=P.nextPawn )
		{
		if ( P.IsA('Balloon') )
			{
			if ( Balloon(P).bCamo && !PBPRI(TowerOwner.PlayerReplicationInfo).bHasCamoDetection)
				{
				//Player doesn't have camo detection na na na naaaaa naaaa :-P
				}
			else
				{
				if ( Vsize(P.Location - Location) < Range )
					{
					if ( Vsize(P.Location - Location) < ClosestOne || ClosestOne == 0 )
						{
						ClosestOne = Vsize(P.Location - Location);
						if ( Target != None )
							Target2 = Target;
						Target = P;
						}
					}
				}
			}
		}
	if ( Target != None )
		{
		Shoot(Target);
		Enemy = Target;
		MyTarget = Target;
		}
	else
		MyTarget = None;
	}

	function Shoot(Pawn Target)
	{
	local Vector FireSpot, ProjStart;
	local Proj_Tower_Slith p,p2;
	local Rotator FireRotation;
	
	PlaySound(FireSound, SLOT_None,5.0);

	ProjStart = Location;
	FireSpot = Target.Location + FMin(1, 0.7 + 0.6 * FRand()) * (Target.Velocity * VSize(Target.Location - ProjStart)/ProjectileType.Default.Speed);
	if ( !FastTrace(FireSpot, ProjStart) )
			FireSpot = 0.5 * (FireSpot + Target.Location);
	FireRotation = Rotator(Target.Location - Location);
	p = Spawn (Class'Proj_Tower_Slith',TowerOwner,,ProjStart,FireRotation);
	P.Velocity *= 3;
	p.instigator = TowerOwner;
	PlayAnim('Shoot1');
	
	if ( PBPRI(PlayerPawn(TowerOwner).PlayerReplicationInfo).SlithLevel >= 2 && Target2 != None)
		{
		FireSpot = Target2.Location + FMin(1, 0.7 + 0.6 * FRand()) * (Target2.Velocity * VSize(Target.Location - ProjStart)/ProjectileType.Default.Speed);
		if ( !FastTrace(FireSpot, ProjStart) )
			FireSpot = 0.5 * (FireSpot + Target2.Location);
		FireRotation = Rotator(Target2.Location - Location);
		p2 = Spawn (Class'Proj_Tower_Slith',TowerOwner,,ProjStart,FireRotation);
		P2.Velocity *= 3;
		p2.instigator = TowerOwner;
		}
	}
}

defaultproperties
{
	 TowerName="Slith Tower"
	 FireSound=Sound'UnrealShare.Skaarj.Clawhit1s'
	 TimerSpeed(1)=1.2
	 TimerSpeed(2)=1.2
	 TimerSpeed(3)=1.2
	 TimerSpeed(4)=1.2
     DrawType=DT_Mesh
     Mesh=LodMesh'UnrealShare.Slith1'
	 DrawScale=0.5
     CollisionRadius=48.000000
     CollisionHeight=44.000000
     RotationRate=(Pitch=3072,Yaw=40000,Roll=6000)
}
